package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.custom.TareaOS2CustomDao;
import com.ejie.ab04b.dao.custom.TramiteOS2CustomDao;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.TareaOS2;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0492s00ServiceImpl generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

@Service(value = "ab0492s00Service")
public class TramiteOS2ServiceImpl implements TramiteOS2Service {

	@Autowired()
	private TramiteOS2CustomDao ab0492s00Dao;
	@Autowired()
	private TareaOS2CustomDao tareaOS2Dao;

	/**
	 * Inserts a single row in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  Ab0492s00
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @return the tramite OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteOS2 add(TramiteOS2 ab0492s00) {
		return this.ab0492s00Dao.add(ab0492s00);
	}

	/**
	 * Updates a single row in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  Ab0492s00
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @return the tramite OS 2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteOS2 update(TramiteOS2 ab0492s00) {
		return this.ab0492s00Dao.update(ab0492s00);
	}

	/**
	 * Finds a single row in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  Ab0492s00
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @return the tramite OS 2
	 */
	public TramiteOS2 find(TramiteOS2 ab0492s00) {
		return (TramiteOS2) this.ab0492s00Dao.vfind(ab0492s00);
	}

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  os2
	 *            OS2
	 *  TramiteOS2
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param os2 the os 2
	 * @return the tramite OS 2
	 */
	public TramiteOS2 findLastTramiteByTipo(Long idTipoTramite, OS2 os2) {
		return (TramiteOS2) this.ab0492s00Dao.findLastTramiteByTipo(
				idTipoTramite, os2);
	}

	/**
	 * Busca un trámite y le carga su lista de tareas asociadas.
	 * 
	 *  tramiteOS2            TramiteOS2
	 *  TramiteOS2
	 *
	 * @param tramiteOS2 the tramite OS 2
	 * @return the tramite OS 2
	 */
	public TramiteOS2 findConTareas(TramiteOS2 tramiteOS2) {

		TramiteOS2 tramiteOS2Aux = (TramiteOS2) this.ab0492s00Dao
				.vfind(tramiteOS2);

		TareaOS2 filterTareaOS2 = new TareaOS2();
		filterTareaOS2.setTramiteOS2(tramiteOS2Aux);
		List<TareaOS2> listaTareas = this.tareaOS2Dao.vfindAll(filterTareaOS2,
				null);

		tramiteOS2Aux.setListaTareas(listaTareas);

		return tramiteOS2Aux;
	}

	/**
	 * Deletes a single row in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TramiteOS2 ab0492s00) {
		this.ab0492s00Dao.remove(ab0492s00);
	}

	/**
	 * Finds a list of rows in the Ab0492s00 table.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0492s00>
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TramiteOS2> findAll(TramiteOS2 ab0492s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TramiteOS2>) this.ab0492s00Dao.vfindAll(ab0492s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0492s00 table using like.
	 * 
	 *  ab0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0492s00>
	 *
	 * @param ab0492s00 the ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TramiteOS2> findAllLike(TramiteOS2 ab0492s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TramiteOS2>) this.ab0492s00Dao.findAllLike(ab0492s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0492s00 table.
	 * 
	 *  filterAb0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0492s00>
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TramiteOS2> filter(TramiteOS2 filterAb0492s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<TramiteOS2> listaAb0492s00 = this.ab0492s00Dao
				.findAllImprimirDocsOS2Like(filterAb0492s00,
						jqGridRequestDto, false);
		Long recordNum = this.ab0492s00Dao
				.findAllLikeImprimirDocsOS2Count(
						filterAb0492s00 != null ? filterAb0492s00
								: new TramiteOS2(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<TramiteOS2>> reorderSelection = this.ab0492s00Dao
					.reorderSelection(filterAb0492s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<TramiteOS2>(jqGridRequestDto,
					recordNum, listaAb0492s00, reorderSelection);
		}
		return new JQGridResponseDto<TramiteOS2>(jqGridRequestDto, recordNum,
				listaAb0492s00);
	}

	/**
	 * Searches rows in the Ab0492s00 table.
	 * 
	 *  filterAb0492s00
	 *            Ab0492s00
	 *  searchAb0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0492s00>>
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param searchAb0492s00 the search ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TramiteOS2>> search(TramiteOS2 filterAb0492s00,
			TramiteOS2 searchAb0492s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0492s00Dao.search(filterAb0492s00, searchAb0492s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0492s00 table.
	 * 
	 *  filterAb0492s00
	 *            Ab0492s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0492s00 the filter ab 0492 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TramiteOS2 filterAb0492s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0492s00Dao.reorderSelection(filterAb0492s00,
				jqGridRequestDto, startsWith);
	}

}
